<?php
require_once 'config.php';
include 'security.php';

// Get the logged-in user's ID
$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;

if($user_id <= 0) {
    header('Location: login.php');
    exit();
}

$search = isset($_REQUEST['search']) ? $_REQUEST['search'] : '';
$category = isset($_REQUEST['category']) ? $_REQUEST['category'] : 'all';
$type = isset($_REQUEST['type']) ? $_REQUEST['type'] : 'all';
$message = '';
$message_type = '';

// Handle delete request
if(isset($_GET['delete']) && !empty($_GET['delete'])) {
    $transaction_id = intval($_GET['delete']);
    
    if($transaction_id > 0) {
        // Verify transaction belongs to user before deleting
        $verify_sql = "SELECT t.transaction_id 
                       FROM transactions t
                       INNER JOIN accounts a ON t.account_id = a.account_id
                       LEFT JOIN shared_users su ON t.account_id = su.account_id
                       WHERE t.transaction_id = " . $transaction_id . "
                         AND (a.user_id = " . $user_id . " OR su.user_id = " . $user_id . ")";
        $verify_result = $mysql->query($verify_sql);
        
        if($verify_result && $verify_result->num_rows > 0) {
            // Delete the transaction
            $delete_sql = "DELETE FROM transactions WHERE transaction_id = " . $transaction_id;
            if($mysql->query($delete_sql)) {
                $message = 'Transaction deleted successfully!';
                $message_type = 'success';
                // Redirect to prevent resubmission
                $redirect_url = 'transactions.php?';
                if(!empty($search)) $redirect_url .= 'search=' . urlencode($search) . '&';
                if($category != 'all') $redirect_url .= 'category=' . urlencode($category) . '&';
                if($type != 'all') $redirect_url .= 'type=' . urlencode($type) . '&';
                $redirect_url .= 'deleted=1';
                header('Location: ' . $redirect_url);
                exit();
            } else {
                $message = 'Error deleting transaction: ' . $mysql->error;
                $message_type = 'error';
            }
        } else {
            $message = 'Transaction not found or you do not have permission to delete it.';
            $message_type = 'error';
        }
    }
}

// Check for success message from redirect
if(isset($_GET['deleted']) && $_GET['deleted'] == 1) {
    $message = 'Transaction deleted successfully!';
    $message_type = 'success';
}

// Build the query directly joining transactions with categories (assisted by AI)
$sql = "SELECT t.transaction_id, t.account_id, t.category_id, t.amount, t.note, t.transaction_date, 
               c.label as category_name, c.type as category_type,
               a.user_id as account_user_id
        FROM transactions t
        INNER JOIN accounts a ON t.account_id = a.account_id
        LEFT JOIN categories c ON t.category_id = c.category_id
        WHERE (a.user_id = " . $user_id . " 
               OR EXISTS (SELECT 1 FROM shared_users su WHERE su.account_id = t.account_id AND su.user_id = " . $user_id . "))";

if(!empty($search)) {
    $sql .= " AND t.note LIKE '%" . $mysql->real_escape_string($search) . "%'";
}

if($category != "all") {
    $sql .= " AND c.label = '" . $mysql->real_escape_string($category) . "'";
}

if($type != "all") {
    $sql .= " AND c.type = '" . $mysql->real_escape_string($type) . "'";
}

$sql .= " ORDER BY t.transaction_date DESC, t.transaction_id DESC";

$results = $mysql->query($sql);

if(!$results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}

$count = $results->num_rows;

// Filter categories by user_id as well
$categories_sql = "SELECT DISTINCT label FROM categories WHERE user_id = " . $user_id . " ORDER BY label";
$categories_result = $mysql->query($categories_sql);
$categories = [];
if($categories_result) {
    while($currentrow = $categories_result->fetch_assoc()) {
        $categories[] = $currentrow['label'];
    }
}
?>
<html>
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <title>Transactions - Budget Buddy</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="transactions-page">
    <?php
    $active_page = 'transactions';
    include 'sidebar.php';
    ?>
    
    <main class="main-content">
        <div class="page-header">
            <h1 class="page-title">Transactions</h1>
            <p class="page-subtitle">View and filter all your transactions</p>
        </div>
        
        <?php if($message): ?>
            <div class="message <?php echo $message_type; ?>" style="padding: 12px; margin-bottom: 20px; border-radius: 6px; <?php echo $message_type == 'success' ? 'background-color: #d4edda; color: #155724; border: 1px solid #c3e6cb;' : 'background-color: #f8d7da; color: #721c24; border: 1px solid #f5c6cb;'; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>
        
        <div class="filter-bar">
            <form method="GET" action="transactions.php" style="display: flex; gap: 10px; align-items: center; width: 100%;">
                <div class="search-box">
                    <input type="text" name="search" placeholder="Search transactions..." class="search-input" value="<?php echo $search; ?>">
                </div>
                <select name="category" class="filter-dropdown">
                    <option value="all" <?php echo $category == 'all' ? 'selected' : ''; ?>>All Categories</option>
                    <?php
                    foreach($categories as $cat) {
                        $selected = ($category == $cat) ? 'selected' : '';
                        echo "<option value=\"" . $cat . "\" $selected>" . $cat . "</option>";
                    }
                    ?>
                </select>
                <select name="type" class="filter-dropdown">
                    <option value="all" <?php echo $type == 'all' ? 'selected' : ''; ?>>All Types</option>
                    <option value="income" <?php echo $type == 'income' ? 'selected' : ''; ?>>Income</option>
                    <option value="expense" <?php echo $type == 'expense' ? 'selected' : ''; ?>>Expense</option>
                </select>
                <button type="submit" style="padding: 8px 16px; background-color: #4CAF50; color: white; border: none; border-radius: 6px; cursor: pointer;">Filter</button>
            </form>
        </div>
        
        <div class="transactions-section">
            <div class="transactions-header">
                <h2 class="section-title">All Transactions</h2>
                <span class="transaction-count"><?php echo $count; ?> transaction<?php echo $count != 1 ? 's' : ''; ?> found</span>
            </div>
            
            <div class="transactions-list">
                <?php
                if($count > 0) {
                    // Reset result pointer
                    $results->data_seek(0);
                    while($currentrow = $results->fetch_assoc()) {
                        $transaction_id = isset($currentrow['transaction_id']) ? intval($currentrow['transaction_id']) : 0;
                        $category_id = isset($currentrow['category_id']) ? intval($currentrow['category_id']) : 0;
                        $description = isset($currentrow['note']) && $currentrow['note'] ? $currentrow['note'] : 'No description';
                        // Only show "Uncategorized" if category_id is NULL or 0 AND category_name is also NULL/empty
                        $category_name = (!empty($currentrow['category_name'])) ? $currentrow['category_name'] : (($category_id > 0) ? 'Category #' . $category_id : 'Uncategorized');
                        $date = isset($currentrow['transaction_date']) ? date('Y-m-d', strtotime($currentrow['transaction_date'])) : date('Y-m-d');
                        $amount = isset($currentrow['amount']) ? number_format(abs($currentrow['amount']), 2) : '0.00';
                        $transaction_type = isset($currentrow['category_type']) && $currentrow['category_type'] ? $currentrow['category_type'] : 'expense';
                        
                        $amount_class = ($transaction_type == 'income') ? 'income' : 'expense';
                        $amount_display = ($transaction_type == 'income') ? '+$' . $amount : '$' . $amount;
                        $category_class = ($transaction_type == 'income') ? 'category-tag income-tag' : 'category-tag';
                        
                        // Build delete URL with current filters
                        $delete_url = 'transactions.php?delete=' . $transaction_id;
                        if(!empty($search)) $delete_url .= '&search=' . urlencode($search);
                        if($category != 'all') $delete_url .= '&category=' . urlencode($category);
                        if($type != 'all') $delete_url .= '&type=' . urlencode($type);
                        ?>
                        <div class="transaction-item">
                            <div class="transaction-info">
                                <div class="transaction-name-row">
                                    <span class="transaction-description"><?php echo htmlspecialchars($description); ?></span>
                                    <span class="<?php echo $category_class; ?>"><?php echo htmlspecialchars($category_name); ?></span>
                                </div>
                                <div class="transaction-date"><?php echo $date; ?></div>
                            </div>
                            <div style="display: flex; align-items: center; gap: 15px;">
                                <div class="transaction-amount <?php echo $amount_class; ?>"><?php echo $amount_display; ?></div>
                                <?php if($transaction_id > 0): ?>
                                    <a href="<?php echo htmlspecialchars($delete_url); ?>" 
                                       class="delete-transaction-btn" 
                                       onclick="return confirm('Are you sure you want to delete this transaction? This action cannot be undone.');"
                                       title="Delete transaction">
                                        🗑️
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    ?>
                    <div style="text-align: center; padding: 40px; color: #666;">
                        <p>No transactions found.</p>
                        <?php if(!empty($search) || $category != 'all' || $type != 'all') { ?>
                            <p style="margin-top: 10px;">
                                <a href="transactions.php" style="color: #4CAF50;">Clear filters</a>
                            </p>
                        <?php } ?>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </main>
</body>
</html>
<?php
$mysql->close();
?>
