<?php
$active_page = isset($active_page) ? $active_page : 'none';
?>

<aside class="sidebar">
    <div class="sidebar-header">
        <div class="logo-icon"><img src="logo2.png" alt="Logo" width="100" height="100" draggable="false"/></div>
        <span class="app-name">Budget Buddy</span>
    </div>
    
    <nav class="main-nav">
        <a href="dashboard.php" class="nav-item <?php echo ($active_page == 'dashboard') ? 'active' : ''; ?>">
            <span class="nav-icon">🏠</span>
            <span class="nav-text">Dashboard</span>
        </a>
        <a href="transactions.php" class="nav-item <?php echo ($active_page == 'transactions') ? 'active' : ''; ?>">
            <span class="nav-icon">💵</span>
            <span class="nav-text">Transactions</span>
        </a>
    </nav>
    
    <div class="quick-add-section">
        <h3 class="section-label">QUICK ADD</h3>
        <a href="add_income.php" class="quick-add-item completed-page <?php echo ($active_page == 'add_income') ? 'active' : ''; ?>">
            <span class="quick-add-icon">📈</span>
            <span class="quick-add-text">Add Income</span>
        </a>
        <a href="add_expense.php" class="quick-add-item completed-page <?php echo ($active_page == 'add_expense') ? 'active' : ''; ?>">
            <span class="quick-add-icon">📉</span>
            <span class="quick-add-text">Add Expense</span>
        </a>
        <a href="add_account.php" class="quick-add-item completed-page <?php echo ($active_page == 'add_account') ? 'active' : ''; ?>">
            <span class="quick-add-icon">👤</span>
            <span class="quick-add-text">Add Account</span>
        </a>
        <a href="#" class="quick-add-item transfer-item">
            <span class="quick-add-icon">↔️</span>
            <span class="quick-add-text">Transfer</span>
        </a>
    </div>
    
    <nav class="other-nav">
        <?php if(isset($_SESSION['is_admin']) && $_SESSION['is_admin'] == 1): ?>
        <a href="admin/index.php" class="nav-item <?php echo ($active_page == 'admin') ? 'active' : ''; ?>">
            <span class="nav-icon">🛠️</span>
            <span class="nav-text">Admin Panel</span>
        </a>
        <?php endif; ?>
        <a href="#" class="nav-item family-nav-item <?php echo ($active_page == 'family') ? 'active' : ''; ?>">
            <span class="nav-icon">👥</span>
            <span class="nav-text">Family</span>
        </a>
        <a href="settings.php" class="nav-item <?php echo ($active_page == 'settings') ? 'active' : ''; ?>">
            <span class="nav-icon">⚙️</span>
            <span class="nav-text">Settings</span>
        </a>
    </nav>
    
    <div class="sidebar-footer">
        <form class="logout-form" action="logout.php" method="post">
            <button type="submit" class="logout-button">
                <span class="nav-icon">🚪</span>
                <span class="nav-text">Logout</span>
            </button>
        </form>
    </div>
</aside>
