<?php
session_start();
$current_page = 'home';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Budget Buddy - Personal Budget Management</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body class="public-page">
    <?php include 'includes/navigation.php'; ?>
    
    <main class="public-content">
        <section class="hero-section">
            <div class="hero-content">
                <h1>Take Control of Your Finances</h1>
                <p class="hero-subtitle">Budget Buddy helps you track income, manage expenses, and achieve your financial goals with ease.</p>
                <div class="hero-buttons">
                    <a href="signup.php" class="btn-light">Get Started Free</a>
                    <a href="features.php" class="btn-secondary">Learn More</a>
                </div>
            </div>
            <div class="hero-image">
                <img src="logo2.png" alt="Budget Buddy" width="300" height="300">
            </div>
        </section>

        <section class="features-preview">
            <h2>Why Choose Budget Buddy?</h2>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">📊</div>
                    <h3>Track Everything</h3>
                    <p>Monitor income and expenses in one place. Get a complete picture of your financial health.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">📈</div>
                    <h3>Visual Insights</h3>
                    <p>Beautiful charts and graphs help you understand your spending patterns and trends.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">💼</div>
                    <h3>Multiple Accounts</h3>
                    <p>Manage checking, savings, credit cards, and more. Keep all your accounts organized.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">🔒</div>
                    <h3>Secure & Private</h3>
                    <p>Your financial data is encrypted and secure. We take your privacy seriously.</p>
                </div>
            </div>
        </section>

        <section class="cta-section">
            <h2>Ready to Start Budgeting?</h2>
            <p>Join thousands of users who are taking control of their finances today.</p>
            <a href="signup.php" class="btn-primary">Create Your Free Account</a>
        </section>
    </main>

    <footer class="site-footer">
        <div class="footer-content">
            <div class="footer-section">
                <h4>Budget Buddy</h4>
                <p>Your personal finance companion</p>
            </div>
            <div class="footer-section">
                <h4>Quick Links</h4>
                <ul>
                    <li><a href="features.php">Features</a></li>
                </ul>
            </div>
            <div class="footer-section">
                <h4>Legal</h4>
                <ul>
                    <li><a href="#">Privacy Policy</a></li>
                    <li><a href="#">Terms of Service</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; <?php echo date('Y'); ?> Budget Buddy. All rights reserved.</p>
        </div>
    </footer>

    <!-- generated styles by AI -->
    <style>
        .public-page {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .public-content {
            flex: 1;
        }
        .hero-section {
            background: linear-gradient(135deg, #1e3a5f 0%, #102a43 100%);
            color: white;
            padding: 80px 2rem;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 4rem;
            max-width: 1200px;
            margin: 0 auto;
        }
        .hero-content h1 {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        .hero-subtitle {
            font-size: 1.25rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }
        .hero-buttons {
            display: flex;
            gap: 1rem;
        }
        .btn-primary, .btn-secondary {
            padding: 12px 24px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
        }
        .btn-primary {
            background-color: #1e3a5f;
            color: white;
            transition: background-color 0.2s;
        }
        .btn-primary:hover {
            background-color: #152a47;
        }
        .btn-light {
            background-color: white;
            color: #1e3a5f;
            padding: 12px 24px;
            border-radius: 6px;
            text-decoration: none;
            font-weight: 600;
            display: inline-block;
            transition: background-color 0.2s;
        }
        .btn-light:hover {
            background-color: #f0f0f0;
        }
        .btn-secondary {
            background-color: rgba(255,255,255,0.1);
            color: white;
            border: 2px solid rgba(255,255,255,0.8);
            transition: all 0.2s;
        }
        .btn-secondary:hover {
            background-color: rgba(255,255,255,0.2);
            border-color: white;
        }
        .features-preview {
            padding: 80px 2rem;
            max-width: 1200px;
            margin: 0 auto;
            background-color: #ffffff;
        }
        .features-preview h2 {
            text-align: center;
            font-size: 2.5rem;
            margin-bottom: 3rem;
            color: #1e3a5f;
        }
        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 2rem;
        }
        .feature-card {
            text-align: center;
            padding: 2rem;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            background-color: #ffffff;
        }
        .feature-icon {
            font-size: 3rem;
            margin-bottom: 1rem;
        }
        .cta-section {
            background-color: #ffffff;
            padding: 100px 2rem;
            text-align: center;
            border-top: 1px solid #eee;
        }
        .site-footer {
            background-color: #1e3a5f;
            color: white;
            padding: 3rem 2rem 1rem;
        }
        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 2rem;
            margin-bottom: 2rem;
        }
        .footer-section ul {
            list-style: none;
            padding: 0;
        }
        .footer-section ul li {
            margin-bottom: 0.5rem;
        }
        .footer-section a {
            color: rgba(255,255,255,0.8);
            text-decoration: none;
        }
        .footer-bottom {
            text-align: center;
            padding-top: 2rem;
            border-top: 1px solid rgba(255,255,255,0.2);
        }
    </style>
</body>
</html>

