<?php
require_once '../config.php';
require_once '../security.php';

$admin_active_page = 'users';

$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

if(empty($_REQUEST['id'])) {
    echo "Error. Please use the Users page.";
    exit();
}

$edit_user_id = intval($_REQUEST['id']);

// Get user data
$sql = "SELECT user_id, first_name, last_name, email, is_admin, created_at
        FROM users
        WHERE user_id = " . $edit_user_id . "
        LIMIT 1";

$result = $mysql->query($sql);

if(!$result || $result->num_rows == 0) {
    echo "User not found.";
    exit();
}

$user = $result->fetch_assoc();

// Handle error messages
$error_message = '';
if(isset($_GET['error'])) {
    if($_GET['error'] == '1') {
        $error_message = 'Please fill in all required fields.';
    } elseif($_GET['error'] == 'email') {
        $error_message = 'Email is already in use by another account.';
    } elseif($_GET['error'] == 'self') {
        $error_message = 'You cannot remove admin status from your own account.';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit User - Admin - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Edit User</h1>
            <p class="admin-subtitle">Editing user #<?php echo $edit_user_id; ?></p>
        </div>

        <?php if($error_message): ?>
            <div class="admin-message error">
                <?php echo htmlspecialchars($error_message); ?>
            </div>
        <?php endif; ?>

        <div class="admin-form-container">
            <form method="GET" action="user_update.php" class="admin-form">
                <input type="hidden" name="id" value="<?php echo $edit_user_id; ?>">

                <div class="form-group">
                    <label for="first_name">First Name *</label>
                    <input type="text" id="first_name" name="first_name" 
                           value="<?php echo htmlspecialchars($user['first_name'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label for="last_name">Last Name *</label>
                    <input type="text" id="last_name" name="last_name" 
                           value="<?php echo htmlspecialchars($user['last_name'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label for="email">Email *</label>
                    <input type="email" id="email" name="email" 
                           value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label for="is_admin">Role *</label>
                    <select id="is_admin" name="is_admin" required>
                        <option value="0" <?php echo (intval($user['is_admin'] ?? 0) == 0) ? 'selected' : ''; ?>>Regular User</option>
                        <option value="1" <?php echo (intval($user['is_admin'] ?? 0) == 1) ? 'selected' : ''; ?>>Administrator</option>
                    </select>
                    <small>Administrators have access to the admin panel</small>
                </div>

                <div class="form-group">
                    <label>Account Created</label>
                    <input type="text" value="<?php echo !empty($user['created_at']) ? date('Y-m-d H:i:s', strtotime($user['created_at'])) : 'N/A'; ?>" disabled style="background-color: #f5f5f5;">
                    <small>This field cannot be changed</small>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-submit">Update User</button>
                    <a href="users.php" class="btn-cancel">Cancel</a>
                </div>
            </form>
        </div>
    </main>

</body>
</html>
<?php
$mysql->close();
?>

