<?php
require_once '../config.php';
require_once '../security.php';

$admin_active_page = 'transactions';

// Check if user is admin
$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

$message = '';
$message_type = '';

// Handle delete request
if(isset($_GET['delete']) && !empty($_GET['delete'])) {
    $transaction_id = intval($_GET['delete']);
    
    if($transaction_id > 0) {
        $delete_sql = "DELETE FROM transactions WHERE transaction_id = " . $transaction_id;
        if($mysql->query($delete_sql)) {
            $message = 'Transaction deleted successfully!';
            $message_type = 'success';
            header('Location: transactions.php?deleted=1');
            exit();
        } else {
            $message = 'Error deleting transaction: ' . $mysql->error;
            $message_type = 'error';
        }
    }
}

// Check for success message from redirect
if(isset($_GET['deleted']) && $_GET['deleted'] == 1) {
    $message = 'Transaction deleted successfully!';
    $message_type = 'success';
}

// Search and filter
$search = isset($_REQUEST['search']) ? trim($_REQUEST['search']) : '';
$category_filter = isset($_REQUEST['category']) ? trim($_REQUEST['category']) : 'all';
$type_filter = isset($_REQUEST['type']) ? trim($_REQUEST['type']) : 'all';

// Build query
$sql = "SELECT t.transaction_id, t.account_id, t.category_id, t.amount, t.note, t.transaction_date,
               c.label as category_name, c.type as category_type,
               a.name as account_name, a.user_id as account_user_id,
               u.first_name, u.last_name, u.email
        FROM transactions t
        LEFT JOIN accounts a ON t.account_id = a.account_id
        LEFT JOIN categories c ON t.category_id = c.category_id
        LEFT JOIN users u ON a.user_id = u.user_id
        WHERE 1=1";

if(!empty($search)) {
    $sql .= " AND (t.note LIKE '%" . $mysql->real_escape_string($search) . "%' 
                   OR u.email LIKE '%" . $mysql->real_escape_string($search) . "%')";
}

if($category_filter != "all" && !empty($category_filter)) {
    $sql .= " AND c.label = '" . $mysql->real_escape_string($category_filter) . "'";
}

if($type_filter != "all" && !empty($type_filter)) {
    $sql .= " AND c.type = '" . $mysql->real_escape_string($type_filter) . "'";
}

$sql .= " ORDER BY t.transaction_date DESC, t.transaction_id DESC";

// Get total count for pagination
$count_results = $mysql->query($sql);
if(!$count_results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}
$count = $count_results->num_rows;

// Pagination setup
$records_per_page = 20;
$start = isset($_REQUEST['start']) ? intval($_REQUEST['start']) : 1;
if($start < 1) $start = 1;

$end = $start + $records_per_page - 1;
if($count < $end) {
    $end = $count;
}

// Add LIMIT to main query
$sql .= " LIMIT " . ($start - 1) . ", " . $records_per_page;

$results = $mysql->query($sql);

if(!$results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}

// Get categories for filter dropdown
$categories_sql = "SELECT DISTINCT label FROM categories ORDER BY label";
$categories_result = $mysql->query($categories_sql);
$categories = [];
if($categories_result) {
    while($row = $categories_result->fetch_assoc()) {
        $categories[] = $row['label'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Transactions - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Manage Transactions</h1>
            <p class="admin-subtitle">View, edit, and delete all transactions</p>
        </div>

        <?php if($message): ?>
            <div class="admin-message <?php echo $message_type; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <div class="admin-filter-bar">
            <form method="GET" action="transactions.php" style="display: flex; gap: 10px; align-items: center; flex-wrap: wrap;">
                <div class="search-box">
                    <input type="text" name="search" placeholder="Search transactions..." value="<?php echo htmlspecialchars($search); ?>">
                </div>
                <select name="category" class="filter-dropdown">
                    <option value="all" <?php echo $category_filter == 'all' ? 'selected' : ''; ?>>All Categories</option>
                    <?php foreach($categories as $cat): ?>
                        <option value="<?php echo htmlspecialchars($cat); ?>" <?php echo $category_filter == $cat ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($cat); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                <select name="type" class="filter-dropdown">
                    <option value="all" <?php echo $type_filter == 'all' ? 'selected' : ''; ?>>All Types</option>
                    <option value="income" <?php echo $type_filter == 'income' ? 'selected' : ''; ?>>Income</option>
                    <option value="expense" <?php echo $type_filter == 'expense' ? 'selected' : ''; ?>>Expense</option>
                </select>
                <button type="submit" class="btn-filter">Filter</button>
                <a href="transactions.php" class="btn-clear">Clear</a>
            </form>
        </div>

        <div class="admin-actions">
            <a href="transaction_add.php" class="btn-add">+ Add New Transaction</a>
            <span class="result-count">
                <?php 
                if($count > 0) {
                    echo "Showing " . $start . "-" . $end . " of " . $count . " transaction" . ($count != 1 ? 's' : '');
                } else {
                    echo "No transactions found";
                }
                ?>
            </span>
        </div>

        <div class="admin-table-container">
            <table class="admin-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>User</th>
                        <th>Account</th>
                        <th>Description</th>
                        <th>Category</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if($results->num_rows > 0) {
                        while($row = $results->fetch_assoc()) {
                            $transaction_id = intval($row['transaction_id']);
                            $date = date('Y-m-d', strtotime($row['transaction_date']));
                            $user_name = trim(($row['first_name'] ?? '') . ' ' . ($row['last_name'] ?? ''));
                            $user_email = $row['email'] ?? 'N/A';
                            $account_name = $row['account_name'] ?? 'N/A';
                            $description = $row['note'] ?? 'No description';
                            $category_name = $row['category_name'] ?? 'Uncategorized';
                            $amount = floatval($row['amount']);
                            $transaction_type = $row['category_type'] ?? 'expense';
                            
                            $amount_display = ($amount >= 0) ? '+$' . number_format($amount, 2) : '$' . number_format(abs($amount), 2);
                            $amount_class = ($amount >= 0) ? 'amount-income' : 'amount-expense';
                            ?>
                            <tr>
                                <td><?php echo $transaction_id; ?></td>
                                <td><?php echo $date; ?></td>
                                <td>
                                    <div><?php echo htmlspecialchars($user_name); ?></div>
                                    <div style="font-size: 0.875rem; color: #666;"><?php echo htmlspecialchars($user_email); ?></div>
                                </td>
                                <td><?php echo htmlspecialchars($account_name); ?></td>
                                <td><?php echo htmlspecialchars($description); ?></td>
                                <td><?php echo htmlspecialchars($category_name); ?></td>
                                <td class="<?php echo $amount_class; ?>"><?php echo $amount_display; ?></td>
                                <td>
                                    <a href="transaction_edit.php?id=<?php echo $transaction_id; ?>" class="btn-edit">Edit</a>
                                    <a href="transactions.php?delete=<?php echo $transaction_id; ?>" 
                                       class="btn-delete" 
                                       onclick="return confirm('Are you sure you want to delete this transaction?');">Delete</a>
                                </td>
                            </tr>
                            <?php
                        }
                    } else {
                        ?>
                        <tr>
                            <td colspan="8" style="text-align: center; padding: 2rem; color: #666;">
                                No transactions found.
                            </td>
                        </tr>
                        <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <?php if($count > $records_per_page): ?>
        <div class="pagination-container">
            <?php if($start > 1): ?>
            <form method="GET" action="transactions.php" style="display: inline-block;">
                <input type="hidden" name="start" value="<?php echo max(1, $start - $records_per_page); ?>">
                <input type="hidden" name="search" value="<?php echo htmlspecialchars($search); ?>">
                <input type="hidden" name="category" value="<?php echo htmlspecialchars($category_filter); ?>">
                <input type="hidden" name="type" value="<?php echo htmlspecialchars($type_filter); ?>">
                <button type="submit" class="btn-pagination">← Previous</button>
            </form>
            <?php endif; ?>
            
            <span class="pagination-info">
                Page <?php echo ceil($start / $records_per_page); ?> of <?php echo ceil($count / $records_per_page); ?>
            </span>
            
            <?php if($end < $count): ?>
            <form method="GET" action="transactions.php" style="display: inline-block;">
                <input type="hidden" name="start" value="<?php echo $start + $records_per_page; ?>">
                <input type="hidden" name="search" value="<?php echo htmlspecialchars($search); ?>">
                <input type="hidden" name="category" value="<?php echo htmlspecialchars($category_filter); ?>">
                <input type="hidden" name="type" value="<?php echo htmlspecialchars($type_filter); ?>">
                <button type="submit" class="btn-pagination">Next →</button>
            </form>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </main>

</body>
</html>
<?php
$mysql->close();
?>

