<?php
require_once '../config.php';
require_once '../security.php';

$admin_active_page = 'transactions';

$user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : 0;
if($user_id <= 0) {
    header('Location: ../login.php');
    exit();
}

// Verify admin status
$admin_sql = "SELECT is_admin FROM users WHERE user_id = " . $user_id . " LIMIT 1";
$admin_result = $mysql->query($admin_sql);
if($admin_result && $admin_result->num_rows > 0) {
    $user_data = $admin_result->fetch_assoc();
    if(intval($user_data['is_admin'] ?? 0) != 1) {
        header('Location: ../dashboard.php');
        exit();
    }
} else {
    header('Location: ../dashboard.php');
    exit();
}

$message = '';
$message_type = '';

// Handle form submission
if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $account_id = isset($_POST['account_id']) ? intval($_POST['account_id']) : 0;
    $category_id = isset($_POST['category_id']) ? intval($_POST['category_id']) : 0;
    $amount = isset($_POST['amount']) ? trim($_POST['amount']) : '';
    $note = isset($_POST['note']) ? trim($_POST['note']) : '';
    $transaction_date = isset($_POST['transaction_date']) ? trim($_POST['transaction_date']) : '';

    // Validate
    if(empty($account_id) || empty($amount) || empty($transaction_date)) {
        $message = 'Please fill in all required fields.';
        $message_type = 'error';
    } else {
        $amount_clean = floatval(preg_replace('/[^0-9.-]/', '', $amount));
        
        $sql = "INSERT INTO transactions (account_id, category_id, amount, note, transaction_date) 
                VALUES (" . $account_id . ", " . ($category_id > 0 ? $category_id : 'NULL') . ", 
                        " . $amount_clean . ", 
                        '" . $mysql->real_escape_string($note) . "', 
                        '" . $transaction_date . "')";

        if($mysql->query($sql)) {
            $message = 'Transaction added successfully!';
            $message_type = 'success';
            header('Location: transactions.php?added=1');
            exit();
        } else {
            $message = 'Error adding transaction: ' . $mysql->error;
            $message_type = 'error';
        }
    }
}

// Get accounts for dropdown
$accounts_sql = "SELECT a.account_id, a.name, u.first_name, u.last_name, u.email 
                 FROM accounts a 
                 LEFT JOIN users u ON a.user_id = u.user_id 
                 ORDER BY u.email, a.name";
$accounts_result = $mysql->query($accounts_sql);
$accounts = [];
if($accounts_result) {
    while($row = $accounts_result->fetch_assoc()) {
        $accounts[] = $row;
    }
}

// Get categories for dropdown
$categories_sql = "SELECT category_id, label, type FROM categories ORDER BY type, label";
$categories_result = $mysql->query($categories_sql);
$categories = [];
if($categories_result) {
    while($row = $categories_result->fetch_assoc()) {
        $categories[] = $row;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-P8J7Y3RS27"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-P8J7Y3RS27');
    </script>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Transaction - Admin - Budget Buddy</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="../css/admin.css">
</head>
<body class="admin-page">
    <?php include 'admin_nav.php'; ?>
    
    <main class="admin-main-content">
        <div class="admin-header">
            <h1>Add New Transaction</h1>
            <p class="admin-subtitle">Create a new transaction record</p>
        </div>

        <?php if($message): ?>
            <div class="admin-message <?php echo $message_type; ?>">
                <?php echo htmlspecialchars($message); ?>
            </div>
        <?php endif; ?>

        <div class="admin-form-container">
            <form method="POST" action="transaction_add.php" class="admin-form">
                <div class="form-group">
                    <label for="account_id">Account *</label>
                    <select id="account_id" name="account_id" required>
                        <option value="">Select an account</option>
                        <?php foreach($accounts as $acc): ?>
                            <option value="<?php echo $acc['account_id']; ?>">
                                <?php echo htmlspecialchars($acc['name']); ?> 
                                (<?php echo htmlspecialchars(trim($acc['first_name'] . ' ' . $acc['last_name']) . ' - ' . $acc['email']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="category_id">Category</label>
                    <select id="category_id" name="category_id">
                        <option value="">None (Uncategorized)</option>
                        <?php foreach($categories as $cat): ?>
                            <option value="<?php echo $cat['category_id']; ?>">
                                <?php echo htmlspecialchars($cat['label']); ?> (<?php echo htmlspecialchars($cat['type']); ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="amount">Amount *</label>
                    <input type="text" id="amount" name="amount" placeholder="0.00" required>
                    <small>Positive for income, negative for expenses</small>
                </div>

                <div class="form-group">
                    <label for="note">Description/Note</label>
                    <textarea id="note" name="note" rows="3" placeholder="Transaction description..."></textarea>
                </div>

                <div class="form-group">
                    <label for="transaction_date">Transaction Date *</label>
                    <input type="date" id="transaction_date" name="transaction_date" value="<?php echo date('Y-m-d'); ?>" required>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-submit">Add Transaction</button>
                    <a href="transactions.php" class="btn-cancel">Cancel</a>
                </div>
            </form>
        </div>
    </main>

</body>
</html>
<?php
$mysql->close();
?>

